/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jeeunit.example.service;

import com.googlecode.jeeunit.example.model.Author;
import com.googlecode.jeeunit.example.model.Book;
import java.io.Serializable;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class LibraryService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager em;

    @TransactionAttribute
    public void fillLibrary() {
        if (this.getNumBooks() != 0L) {
            return;
        }
        Author mann = new Author();
        mann.setFirstName("Thomas");
        mann.setLastName("Mann");
        Author steinbeck = new Author();
        steinbeck.setFirstName("John");
        steinbeck.setLastName("Steinbeck");
        Book buddenbrooks = new Book();
        buddenbrooks.setTitle("Buddenbrooks");
        buddenbrooks.setAuthor(mann);
        mann.getBooks().add(buddenbrooks);
        Book eden = new Book();
        eden.setTitle("East of Eden");
        eden.setAuthor(steinbeck);
        steinbeck.getBooks().add(eden);
        this.em.persist((Object)mann);
        this.em.persist((Object)steinbeck);
        this.em.persist((Object)buddenbrooks);
        this.em.persist((Object)eden);
    }

    @TransactionAttribute
    public List<Book> findBooksByAuthor(String lastName) {
        String jpql = "select b from Book b where b.author.lastName = :lastName";
        TypedQuery query = this.em.createQuery(jpql, Book.class);
        query.setParameter("lastName", (Object)lastName);
        List books = query.getResultList();
        return books;
    }

    @TransactionAttribute
    public List<Book> findBooksByTitle(String title) {
        String jpql = "select b from Book b where b.title = :title";
        TypedQuery query = this.em.createQuery(jpql, Book.class);
        query.setParameter("title", (Object)title);
        List books = query.getResultList();
        return books;
    }

    @TransactionAttribute
    public long getNumBooks() {
        String jpql = "select count(b) from Book b";
        Long numBooks = (Long)this.em.createQuery(jpql).getSingleResult();
        return numBooks;
    }
}

