package com.googlecode.jpattern.gwt.client;

import com.googlecode.jpattern.gwt.client.cache.CacheService;
import com.googlecode.jpattern.gwt.client.cache.ICacheService;
import com.googlecode.jpattern.gwt.client.history.IHistoryService;
import com.googlecode.jpattern.gwt.client.history.NullHistoryService;
import com.googlecode.jpattern.gwt.client.logger.ILoggerService;
import com.googlecode.jpattern.gwt.client.logger.NullLoggerService;
import com.googlecode.jpattern.gwt.client.serializer.ISerializerService;
import com.googlecode.jpattern.gwt.client.serializer.NullSerializerService;

/**
 * 
 * @author Francesco Cina'
 *
 * 12 Apr 2011
 */
public class NullApplicationProvider implements IApplicationProvider {

	@Override
	public ILoggerService getLoggerService() {
		return new NullLoggerService();
	}

	@Override
	public IService getService(String serviceName) {
		return new NullService();
	}

	@Override
	public IServerCallService getServerCallService() {
		return new NullServerCallService();
	}

	@Override
	public ISerializerService getSerializerService() {
		return new NullSerializerService();
	}

	@Override
	public ICacheService getCacheService() {
		return new CacheService();
	}

	@Override
	public IHistoryService getHistoryService() {
		return new NullHistoryService();
	}

}
