package com.googlecode.jpattern.gwt.client.cache;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * @author Francesco Cina
 *
 * 26/lug/2011
 */
public class CacheService implements ICacheService {

	private Map<String, ICache> cacheMap = new HashMap<String, ICache>();
	
	@Override
	public ICache getCache(String cacheName) {
		if (cacheMap.containsKey(cacheName)) {
			return cacheMap.get(cacheName);
		}
		return new NullCache();
	}

	@Override
	public void registerCache(String cacheName, ICache cache) {
		cacheMap.put(cacheName, cache);		
	}

}
