package com.googlecode.jpattern.gwt.client.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * @author Francesco Cina'
 *
 */
public class CommandChain extends ACommand {

	List<ACommand> commands = new ArrayList<ACommand>();
	private Iterator<ACommand> commandIterator;
	
	@Override
	public void exec(IResult commandResult) {
		commandIterator = commands.iterator();
		callback(commandResult);
	}
	
	protected void callback(IResult commandResult) {
		if (commandIterator.hasNext() && commandResult.getErrorMessages().isEmpty()) {
			ACommand nextCommand = commandIterator.next();
			nextCommand.visit(getProvider());
			nextCommand.exec(new CommandChainCallBack());
		} else {
			getCommandCallBack().callback(commandResult);
		}
	}
	
	public void addCommand(ACommand command) {
		commands.add(command);
	}
	
	
	class CommandChainCallBack implements ICommandCallBack {
		
		@Override
		public void callback(IResult commandResult) {
			CommandChain.this.callback(commandResult);
		}

	}
}
