package com.googlecode.jpattern.gwt.client.command;

import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * Abstract class to implement a command which DOESN'T perform asynchronous calls.
 * This class expect that the execute() method perform only synchronous operations;
 * when the method execute() ends his execution a callback is automatically called
 * to communicate that the command ends his execution.
 * 
 * 
 * @author Francesco Cina
 *
 * 06/lug/2011
 */
public abstract class SynchronousCommand extends ACommand {

	@Override
	protected void exec(IResult commandResult) {
		execute(commandResult);
		callback(commandResult);
	}

	protected abstract void execute(IResult commandResult);

}
