package com.googlecode.jpattern.gwt.client.command.impl;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.googlecode.jpattern.gwt.client.command.ACommand;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.shared.result.ErrorMessage;
import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * @author Francesco Cina'
 *
 * 10/mag/2011
 */
public class GetTextResourceCommand extends ACommand {

	private final StringBuffer url;
	private final StringBuffer fileContent;

	public GetTextResourceCommand(StringBuffer url, StringBuffer fileContent) {
		this.url = url;
		this.fileContent = fileContent;
	}

	@Override
	protected void exec(final IResult commandResult) {
		final ILogger logger = getProvider().getLoggerService().getLogger(this.getClass());
		try {
			new RequestBuilder(RequestBuilder.GET, url.toString()).sendRequest("", new RequestCallback() {
				
				@Override
				public void onResponseReceived(Request request, Response response) {
					fileContent.append(response.getText());					
					callback(commandResult);
				}
				
				@Override
				public void onError(Request request, Throwable exception) {
					logger.error("RequestCallback error for resource " + url.toString(), exception);
					commandResult.getErrorMessages().add(new ErrorMessage("GetTextResourceCommand", "error.getting.file", new String[]{url.toString()}));
					callback(commandResult);
				}
			});
		} catch (RequestException e) {
			logger.error("Request Resource error for resource: " + url.toString(), e);
			commandResult.getErrorMessages().add(new ErrorMessage("GetTextResourceCommand", "error.getting.file", new String[]{url.toString()}));
			callback(commandResult);
		}
	}

}
