package com.googlecode.jpattern.gwt.client.communication.direct;

import com.googlecode.jpattern.gwt.client.ApplicationProxy;
import com.googlecode.jpattern.gwt.client.communication.AProxy;
import com.googlecode.jpattern.gwt.client.communication.ICallbackAction;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;

/**
 * 
 * @author Francesco Cina'
 *
 * @param <T>
 */
public class PutProxy<T extends ICommandFacadeResult<?>,Z> extends AProxy<T> {

	private final String url;
	private final Z data;
	private final IServerCallPutAction serverCallPostAction;
	private final Class<T> resultClass;
	private final Class<Z> dataClass;

	public PutProxy(IServerCallPutAction serverCallPostAction, Class<T> resultClass, Class<Z> dataClass, ICallbackAction<T> callbackAction, String url, Z data) {
		super(callbackAction);
		this.serverCallPostAction = serverCallPostAction;
		this.resultClass = resultClass;
		this.dataClass = dataClass;
		this.url=url;
		this.data = data;
	}
	
	@Override
	protected void execute(ICallbackAction<T> callbackAction) throws Exception {
		ILogger logger = ApplicationProxy.getInstance().getApplicationProvider().getLoggerService().getLogger(this.getClass());
		
		logger.info("Begin execute - call URL " + url);

		try {
			callbackAction.onSuccess( serverCallPostAction.put(resultClass, dataClass, url, data) );
		} catch (Exception e) {
			callbackAction.onError(e);
		}
	}

}
