package com.googlecode.jpattern.gwt.client.communication.rest;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.googlecode.jpattern.gwt.client.ApplicationProxy;
import com.googlecode.jpattern.gwt.client.communication.ICallbackAction;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.gwt.client.serializer.IObjectSerializer;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;

/**
 * 
 * @author Francesco Cina'
 *
 */
public class ProxyRequestCallback<T extends ICommandFacadeResult<?>> implements RequestCallback {

	private final ICallbackAction<T> callbackAction;
	private final IObjectSerializer<T> jsonBuilder;
	private final ILogger logger;

	public ProxyRequestCallback(ICallbackAction<T> callbackAction, IObjectSerializer<T> jsonBuilder) {
		this.callbackAction = callbackAction;
		this.jsonBuilder = jsonBuilder;
		logger = ApplicationProxy.getInstance().getApplicationProvider().getLoggerService().getLogger(this.getClass());
	}
	
	@Override
	public void onError(Request request, Throwable exception) {
		logger.error("RequestCallback error", exception);
		callbackAction.onError(exception);
	}

	@Override
	public void onResponseReceived(Request request, Response response) {
		logger.debug("RequestCallBack OK. StatusCode: [" + response.getStatusCode() + "] StatusText: [" + response.getStatusText() + "]");
		logger.debug("Code received:");
		logger.debug(response.getText());
		T result;
		try {
			result = jsonBuilder.deserialize( response.getText());
			if (result!=null) {
				callbackAction.onSuccess( result ); 
			} else {
				callbackAction.onError(new Exception("Server call result is null"));
			}
		} catch (Exception e) {
			logger.error("RequestCallback parsing JSON error", e);
		}
	}
}
