package com.googlecode.jpattern.gwt.client.history;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.googlecode.jpattern.gwt.client.navigationevent.RootNavigationEvent;
import com.googlecode.jpattern.gwt.client.presenter.ARootPresenter;
import com.googlecode.jpattern.gwt.client.presenter.IPresenter;
import com.googlecode.jpattern.gwt.client.presenter.NullPresenter;
import com.googlecode.jpattern.gwt.client.presenter.NullRootPresenter;

/**
 * 
 * @author Francesco Cina
 *
 * 27/lug/2011
 */
public class FixedSizeHistoryManager implements IHistoryManager {
	
	private static String TOKEN_SEPARATOR = "_";

//	private int count = 0;
	private final int historySize;
	private final Map<String, IPresenter> historyMap = new LinkedHashMap<String, IPresenter>();
	private final List<String> tokenList = new ArrayList<String>();
	private final IHistoryManagerObserver historyManagerObserver;
	private final IHistoryEngine historyEngine;
	private List<IPresenter> presenterHierarchy = new ArrayList<IPresenter>();

	private ARootPresenter rootPresenter = new NullRootPresenter();

	public FixedSizeHistoryManager(int historySize, IHistoryManagerObserver historyManagerObserver, IHistoryEngine historyEngine) {
		this.historySize = historySize;
		this.historyManagerObserver = historyManagerObserver;
		this.historyEngine = historyEngine;
		historyEngine.init(this);
	}

	@Override
	public void onEvent(String eventName) {
		int hello;
		System.out.println("------------ EVENT CALLED: " + eventName);
		String[] tokens = generateTokenList( eventName );
		PresenterEvents presenterEvents = generatePresenterEventsAssociation(presenterHierarchy, tokens);
		launchEvents(presenterEvents );
//		IPresenter presenter = historyMap.get(event.getValue());
//		if (presenter!=null) {
//			int ToChangeHere;
//			System.out.println("change called: " + event);
////			presenter.render();
//		}
	}

	@Override
	public void registerHistory(IPresenter presenter) {
		presenterHierarchy = new ArrayList<IPresenter>();
		presenter.hierarchy( presenterHierarchy );
		String token = "";
		if (presenterHierarchy.size()>0) {
			token = generateTokenString(presenterHierarchy);
			historyMap.put(token, presenter);
			tokenList.add(token);
			historyEngine.registerEvent(token);
			checkHistorySize();
		}
		historyManagerObserver.onRegisterHistory(historyMap, tokenList, token, presenterHierarchy);
	}

	private void checkHistorySize() {
		if ( tokenList.size() > historySize ) {
			String token = tokenList.get(0);
			historyMap.remove(token);
			tokenList.remove(0);
		}
	}
	
	public String generateTokenString(List<IPresenter> presenterHierarchy) {
		StringBuffer token = new StringBuffer();
		for (IPresenter presenter : presenterHierarchy) {
			token.append( presenter.getNavigationEvent().getName() );
			token.append(TOKEN_SEPARATOR);
		}
		return token.toString();
	}
	
	public String[] generateTokenList(String tokenString) {
		String[] result = tokenString.split(TOKEN_SEPARATOR);
		return result;
	}
	
	public PresenterEvents generatePresenterEventsAssociation(List<IPresenter> presenterList, String[] tokenList) {
		IPresenter presenter = rootPresenter;
//		int index = 
//		for (int i=0; i<tokenList.length; i++) {
//			if (i<presenterList.size()) {
//				if ( presenterList.get(i).getNavigationEvent().getName().equals(tokenList[i])  ) {
//					presenter = presenterList.get(i);
//				}
//			}
//		}
		PresenterEvents presenterEvents = new PresenterEvents(presenter);
		for (String token : tokenList) {
			presenterEvents.addEvents(token);
		}
		return presenterEvents;
	}
	
	
	public void launchEvents(PresenterEvents presenterEvents) {
		IPresenter presenter = presenterEvents.getPresenter();
		for (String event : presenterEvents.getEvents()) {
			if (event.length()>0) {
				int hello;
				System.out.println("------------ LAUNCH EVENT: " + event);
				presenter = presenter.launchNavigationEvent(event, false);
			}
		}
		if (presenterEvents.getEvents().size()==1 && presenterEvents.getEvents().get(0).equals("")) {
			new RootNavigationEvent(rootPresenter).startApplication();
		}
	}
	
	class PresenterEvents {
		
		private final IPresenter presenter;
		private final List<String> events = new ArrayList<String>();

		PresenterEvents(IPresenter presenter) {
			this.presenter = presenter;
		}

		public void addEvents(String event) {
			events.add( event );
		}

		public List<String> getEvents() {
			return events;
		}

		public IPresenter getPresenter() {
			return presenter;
		}
	}

	@Override
	public void setRootPresenter(ARootPresenter rootPresenter) {
		this.rootPresenter = rootPresenter;
	}

	@Override
	public void updateState() {
		historyEngine.updateState();		
	}

}
