package com.googlecode.jpattern.gwt.client.history;

/**
 * A service to store a fixed number of history steps
 * 
 * @author Francesco Cina
 *
 * 27/lug/2011
 */
public class FixedSizeHistoryService implements IHistoryService {

	private final IHistoryManager historyManager;
	
	public FixedSizeHistoryService(int historySize) {
		this(historySize, new NullHistoryManagerObserver(), new GWTHistoryEngine());
	}
	
	public FixedSizeHistoryService(int historySize, IHistoryManagerObserver historyManagerObserver, IHistoryEngine historyEngine) {
		historyManager = new FixedSizeHistoryManager(historySize, historyManagerObserver, historyEngine);
	}
	
	@Override
	public IHistoryManager getHistoryManager() {
		return historyManager;
	}

}
