package com.googlecode.jpattern.gwt.client.logger;

/**
 * 
 * @author Francesco Cina'
 *
 * 12 Apr 2011
 */
public class SysoutLogger implements ILogger {

	private final String name;

	public SysoutLogger(String name) {
		this.name = name;
	}

	@Override
	public void trace(String message) {
		System.out.println(format("TRACE", message));
	}

	@Override
	public void debug(String message) {
		System.out.println(format("DEBUG", message));
	}

	@Override
	public void info(String message) {
		System.out.println(format("INFO ", message));
	}

	@Override
	public void warn(String message) {
		System.out.println(format("WARN ", message));
	}

	@Override
	public void error(String message, Throwable e) {
		System.out.println(format("ERROR", message));
		e.printStackTrace();
	}

	private String format(String level, String message) {
		return "[" + level + "] [" + name + "] [" + message + "]";
	}
}
