package com.googlecode.jpattern.gwt.client.navigationevent;

import com.googlecode.jpattern.gwt.client.ApplicationProxy;
import com.googlecode.jpattern.gwt.client.IApplicationProvider;
import com.googlecode.jpattern.gwt.client.presenter.IPresenter;
import com.googlecode.jpattern.gwt.client.presenter.NullPresenter;

/**
 * 
 * @author Francesco Cina
 *
 * 01/ago/2011
 */
public abstract class ANavigationEvent implements INavigationEvent {

	private IApplicationProvider provider;
	private final String eventName;

	public ANavigationEvent(String eventName) {
		this(eventName, ApplicationProxy.getInstance().getApplicationProvider());
	}
	
	public ANavigationEvent(String eventName, IApplicationProvider provider) {
		this.eventName = eventName;
		this.provider = provider;
	}
	
	@Override
	public final IPresenter launch(IPresenter parentPresenter, boolean registerHistory) {
		IPresenter presenter = exec();
		presenter.setParent(parentPresenter);
		if (registerHistory) {
			getProvider().getHistoryService().getHistoryManager().registerHistory(presenter);
		} else {
			presenter.onEventStart();
			presenter.init();
			parentPresenter.getView().onNavigationEvent(getName());
		}
		return presenter;
	}
	
	@Override
	public final IPresenter launch(IPresenter parentPresenter, boolean registerHistory, IPresenter presenter) {
		if ((presenter==null) || (presenter instanceof NullPresenter)) {
			return launch(parentPresenter, registerHistory);
		}
		presenter.render(parentPresenter);
		return presenter;
	}
	
	/**
	 * Return the newly created presenter
	 * @return
	 */
	public abstract IPresenter exec(); 
	
	protected IApplicationProvider getProvider() {
		if (provider == null) {
			provider = ApplicationProxy.getInstance().getApplicationProvider();
		}
		return provider;
	}
	
	public final String getName() {
		return eventName;
	}
}
