package com.googlecode.jpattern.gwt.client.navigationevent;

import com.googlecode.jpattern.gwt.client.presenter.IPresenter;

/**
 * 
 * An event to manage the web navigation through managed IPresenter creation 
 * 
 * @author Francesco Cina'
 *
 * 28/07/2011
 */
public interface INavigationEvent {

	/**
	 * Launch a new navigation event using a specific parentPresenter.
	 * A new presenter instance is created and associated to the parentPresenter.
	 * @param parentPresenter
	 * @param registerHistory indicate if the event must be registered in the navigation history, this must be true only if the event has been thrown by an explicit user action
	 */
	IPresenter launch(IPresenter parentPresenter, boolean registerHistory);
	
	/**
	 * Launch a new navigation event.
	 * In this case an existing presenter is associated with a specific parentPresenter.
	 * if the presenter is null or is an instance of NullPresenter the method launch(IPresenter parentPresenter)
	 * is called and a new presenter is created.
	 * @param parentPresenter
	 * @param registerHistory indicate if the event must be registered in the navigation history, this must be true only if the event has been thrown by an explicit user action
	 * @param presenter
	 */
	IPresenter launch(IPresenter parentPresenter, boolean registerHistory, IPresenter presenter);
	
	String getName();
	
}