package com.googlecode.jpattern.gwt.client.navigationevent;

import com.googlecode.jpattern.gwt.client.history.IHistoryManager;
import com.googlecode.jpattern.gwt.client.presenter.ARootPresenter;
import com.googlecode.jpattern.gwt.client.presenter.IPresenter;
import com.googlecode.jpattern.gwt.client.presenter.NullPresenter;

/**
 * 
 * @author Francesco Cina
 *
 * 03/ago/2011
 */
public class RootNavigationEvent extends ANavigationEvent {

	private final ARootPresenter rootPresenter;

	public RootNavigationEvent(ARootPresenter rootPresenter) {
		super("");
		this.rootPresenter = rootPresenter;
	}

	public void startApplication() {
		launch(new NullPresenter(), false);
		IHistoryManager historyManager = getProvider().getHistoryService().getHistoryManager();
		historyManager.setRootPresenter(rootPresenter);
		historyManager.updateState();
	}
	
	@Override
	public IPresenter exec() {
		return rootPresenter;
	}

}
