package com.googlecode.jpattern.gwt.client.presenter;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.RootPanel;
import com.googlecode.jpattern.gwt.client.navigationevent.NullNavigationEvent;
import com.googlecode.jpattern.gwt.client.view.DefaultShowViewStrategy;
import com.googlecode.jpattern.gwt.client.view.IErrorArea;
import com.googlecode.jpattern.gwt.client.view.IView;
import com.googlecode.jpattern.gwt.client.view.NullErrorArea;

/**
 * This class represent the root Presenter.
 * It must be the parent of the Presenter instance created as entry point for a MVP application. 
 * 
 * @author Francesco Cina
 *
 * 02/ago/2011
 */
public abstract class ARootPresenter extends APresenter<ARootPresenter.RootView> {

	public ARootPresenter() {
		super(new DefaultShowViewStrategy<ARootPresenter.RootView>(new ARootPresenter.RootView()), new NullNavigationEvent());
	}

	protected HasWidgets rootPanel() {
		return RootPanel.get();
	}
	
	@Override
	public void postDisplay() {
	}

	static class RootView implements IView {

		private IPresenter presenter;

		RootView() {
		}
		
		@Override
		public void visit(IPresenter presenter) {
			this.presenter = presenter;
		}

		@Override
		public IPresenter getPresenter() {
			return presenter;
		}

		@Override
		public void render(HasWidgets container) {
		}

		@Override
		public IErrorArea getErrorArea() {
			return new NullErrorArea();
		}

		@Override
		public void onNavigationEvent(String eventName) {
		}

	}

}
