package com.googlecode.jpattern.gwt.client.presenter;

import java.util.List;

import com.google.gwt.user.client.ui.HasWidgets;
import com.googlecode.jpattern.gwt.client.navigationevent.INavigationEvent;
import com.googlecode.jpattern.gwt.client.navigationevent.INavigationEventCallback;
import com.googlecode.jpattern.gwt.client.navigationevent.INavigationEventData;
import com.googlecode.jpattern.gwt.client.view.IView;
import com.googlecode.jpattern.shared.result.IErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 * 20 Apr 2011
 */
public interface IPresenter {

	/**
	 * Return the navigationEvent which generated the presenter
	 * @return
	 */
	INavigationEvent getNavigationEvent();
	
	/**
	 * Clear the error area before the execution of a new event
	 */
	void onEventStart();
	
	/**
	 * Called by the IEvent when the result of the execution is not valid
	 * @param errorMessages
	 */
	void onEventError(List<IErrorMessage> errorMessages);
	
	/**
	 * Bind the presenter's view with his container
	 */
	void render();
	
	/**
	 * Bind the presenter's view with a specific container
	 */
	void render(IPresenter parentPresenter);

	/**
	 * Initialize the presenter and show the related IView
	 */
	void init();

	/**
	 * Set the parent presenter
	 * @param parentPresenter
	 */
	void setParent(IPresenter parentPresenter);
	
	/**
	 * Return an ordered list of all the presenters in the current hierarchy, from the root parent to the leaf
	 * @return
	 */
	void hierarchy(List<IPresenter> hierarchyResult);

	/**
	 * Return the IView object associated with this presenter
	 * @return
	 */
	IView getView();
	
	/**
	 * Register a new navigation event throwable by the current presenter
	 * @param navigationEvent
	 * @param eventTarget the target area where the new view will be rendered
	 * @param navigationEventCallback
	 */
	void registerNavigationEvent(INavigationEvent navigationEvent, HasWidgets eventTarget, INavigationEventCallback navigationEventCallback);
	
	/**
	 * Launch a navigation event based on his name.
	 * If an event with that name is present in the current Presenter is thrown, otherwise the event is propagated to the parent presenter 
	 * @param navigationEventName
	 * @param registerHistory indicate if the event must be registered in the navigation history, this must be true only if the event has been thrown by an explicit user action
	 */
	IPresenter launchNavigationEvent(String navigationEventName, boolean registerHistory);
	
	/**
	 * Launch a navigation event based on his name. the event is catch by only by the presenter whose name is presenterName
	 * @param navigationEventName
	 * @param registerHistory indicate if the event must be registered in the navigation history, this must be true only if the event has been thrown by an explicit user action
	 * @param presenterName the name of a Presenter in the presenters hierarchy. To launch the event on the root
	 * presenter use the empty String ""
	 */
	IPresenter launchNavigationEvent(String navigationEventName, boolean registerHistory, String presenterName);
	
	/**
	 * Return information related to a specific INavigationEvent
	 * @return
	 */
	INavigationEventData getNavigationEventData(String navigationEventName);

}
