package com.googlecode.jpattern.gwt.client.presenter;

import java.util.List;

import com.google.gwt.user.client.ui.HasWidgets;
import com.googlecode.jpattern.gwt.client.navigationevent.INavigationEvent;
import com.googlecode.jpattern.gwt.client.navigationevent.INavigationEventCallback;
import com.googlecode.jpattern.gwt.client.navigationevent.INavigationEventData;
import com.googlecode.jpattern.gwt.client.navigationevent.NullNavigationEvent;
import com.googlecode.jpattern.gwt.client.navigationevent.NullNavigationEventData;
import com.googlecode.jpattern.gwt.client.view.IView;
import com.googlecode.jpattern.gwt.client.view.NullView;
import com.googlecode.jpattern.shared.result.IErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 */
public class NullPresenter implements IPresenter {

	@Override
	public void onEventError(List<IErrorMessage> errorMessages) {
	}

	@Override
	public void onEventStart() {
	}

	@Override
	public void render() {
	}
	
	@Override
	public void render(IPresenter parentPresenter) {
	}

	@Override
	public void init() {
	}

	@Override
	public void hierarchy(List<IPresenter> hierarchyResult) {
	}

	@Override
	public IView getView() {
		return new NullView();
	}

	@Override
	public void registerNavigationEvent(INavigationEvent navigationEvent, HasWidgets eventTarget, INavigationEventCallback navigationEventCallback) {
		
	}

	@Override
	public INavigationEventData getNavigationEventData(String navigationEventName) {
		return new NullNavigationEventData();
	}

	@Override
	public IPresenter launchNavigationEvent(String navigationEventName, boolean registerHistory) {
		return new NullPresenter();
	}

	@Override
	public IPresenter launchNavigationEvent(String navigationEventName, boolean registerHistory, String parentName) {
		return new NullPresenter();
	}

	@Override
	public INavigationEvent getNavigationEvent() {
		return new NullNavigationEvent();
	}

	@Override
	public void setParent(IPresenter parentPresenter) {
	}

}
