package com.googlecode.jpattern.gwt.client.view;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasWidgets;
import com.googlecode.jpattern.gwt.client.presenter.IPresenter;

/**
 * 
 * @author Francesco Cina'
 *
 * 20 Apr 2011
 */
public abstract class AGwtView<T extends IPresenter> extends Composite implements IView {

	private T presenter;
	private IErrorArea errorArea;
//	private HasWidgets defaultNavigationTarget = new NullHasWidgets();
//	private Map<String, HasWidgets> navigationTargets = new HashMap<String, HasWidgets>();
	
	@Override
	public final void render(HasWidgets container) {
		if (container!=null) {
		    container.clear();
		    container.add(this);
		}
	}
	

	@SuppressWarnings("unchecked")
	@Override
	public final void visit(IPresenter presenter) {
		this.presenter = (T) presenter;
	}

	@Override
	public final T getPresenter() {
		return presenter;
	}

	@Override
	public final IErrorArea getErrorArea() {
		if (errorArea == null) {
			errorArea = buildErrorArea();
		}
		return errorArea;
	}

//	@Override
//	public final void registerDefaultEventTarget(HasWidgets hasWidgets) {
//		this.defaultNavigationTarget  = hasWidgets;
//	}
//	
//	@Override
//	public final void registerEventTarget(String navigationEventName, HasWidgets hasWidgets) {
//		navigationTargets.put(navigationEventName, hasWidgets);
//	}
//	
//	@Override
//	public final HasWidgets getNavigationTarget(String navigationEventName) {
//		if (navigationTargets.containsKey(navigationEventName)) {
//			return navigationTargets.get(navigationEventName);
//		}
//		return defaultNavigationTarget;
//	}

	
	protected abstract IErrorArea buildErrorArea();
	
}
