package com.googlecode.jpattern.gwt.client.view;

import java.util.List;

import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Panel;
import com.googlecode.jpattern.gwt.client.ui.UlListPanel;
import com.googlecode.jpattern.shared.result.IErrorMessage;

/**
 * Define an IErrorArea which shows the errors added in a UIList
 * @author cinafr
 *
 */
public class DefaultUlErrorArea implements IErrorArea {

	private final UlListPanel listPanel;
	private final Panel errorPanel;

	public DefaultUlErrorArea(Panel errorPanel) {
		errorPanel.setVisible(false);
		this.errorPanel = errorPanel;
		this.listPanel = new UlListPanel();
		errorPanel.add(listPanel);
	}
	
	@Override
	public void addErrorMessage(IErrorMessage errorMessage) {
		errorPanel.setVisible(true);
		listPanel.add(new InlineLabel(errorMessage.getName() + " " + errorMessage.getMessage()));
	}

	@Override
	public void addErrorMessages(List<IErrorMessage> errorMessages) {
		for (IErrorMessage errorMessage : errorMessages) {
			addErrorMessage(errorMessage);
		}
	}

	@Override
	public void clear() {
		listPanel.clear();
		errorPanel.setVisible(false);
	}

}
