package com.googlecode.jpattern.gwt.client.view;

import com.google.gwt.user.client.ui.HasWidgets;

/**
 * 
 * @author Francesco Cina
 *
 * 19/lug/2011
 */
public interface IShowViewStrategy<T extends IView> {

	/**
	 * Return the view associated with the strategy
	 * @return
	 */
	T getView();
	
	/**
	 * this is called when an asynchronous action begins
	 */
	void onLoadStart(HasWidgets container);
	
	/**
	 * This is called when a started asynchronous action ends its execution.
	 * The container used is the same of the one used for the onLoadStart(...) phase
	 */
	void onLoadCompleted();
	
	/**
	 * This is called when a started asynchronous action ends its execution
	 */
	void onLoadCompleted(HasWidgets container);
	
}
