package com.googlecode.jpattern.gwt.client;

import java.util.HashMap;
import java.util.Map;

import com.googlecode.jpattern.gwt.client.cache.CacheService;
import com.googlecode.jpattern.gwt.client.cache.ICacheService;
import com.googlecode.jpattern.gwt.client.history.IHistoryService;
import com.googlecode.jpattern.gwt.client.history.NullHistoryService;
import com.googlecode.jpattern.gwt.client.logger.ILoggerService;
import com.googlecode.jpattern.gwt.client.logger.NullLoggerService;
import com.googlecode.jpattern.gwt.client.serializer.ISerializerService;
import com.googlecode.jpattern.gwt.client.serializer.NullSerializerService;

/**
 * 
 * @author Francesco Cina'
 *
 * 12 Apr 2011
 */
public abstract class AApplication implements IApplicationProvider, IApplicationSystem {

	private ISerializerService serializerService = new NullSerializerService();
	private ILoggerService loggerService = new NullLoggerService();
	private IServerCallService serverCallService = new RestServerCallService();
	private Map<String, IService> serviceMap = new HashMap<String, IService>();
	private ICacheService cacheService = new CacheService();
	private IHistoryService historyService = new NullHistoryService();

	@Override
	public ILoggerService getLoggerService() {
		return loggerService;
	}
	
	@Override
	public void setLoggerService(ILoggerService loggerService) {
		if (loggerService!=null) {
			this.loggerService = loggerService;
		}
	}
	
	@Override
	public IServerCallService getServerCallService() {
		return serverCallService;
	}
	
	@Override
	public void setServerCallService(IServerCallService serverCallService) {
		if (serverCallService!=null) {
			this.serverCallService = serverCallService;
		}
	}
	
	@Override
	public IService getService(String serviceName) {
		if (serviceMap.containsKey(serviceName)) {
			return serviceMap.get(serviceName);
		}
		return new NullService();
	}
	
	@Override
	public void addService(String serviceName, IService service){
		serviceMap.put(serviceName, service);
	}

	@Override
	public ISerializerService getSerializerService() {
		return serializerService;
	}

	@Override
	public void setSerializerService(ISerializerService serializerService) {
		this.serializerService = serializerService;
	}
	
	@Override
	public ICacheService getCacheService() {
		return cacheService ;
	}
	
	@Override
	public IHistoryService getHistoryService() {
		return historyService;
	}

	@Override
	public void setHistoryService(IHistoryService historyService) {
		this.historyService = historyService;
	}

}
