package com.googlecode.jpattern.gwt.client;

import java.util.Map;

import com.googlecode.jpattern.gwt.client.communication.AProxy;
import com.googlecode.jpattern.gwt.client.communication.ICallbackAction;
import com.googlecode.jpattern.gwt.client.communication.NullProxy;
import com.googlecode.jpattern.gwt.client.serializer.IObjectSerializer;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;

/**
 * 
 * @author Francesco Cina'
 *
 * 06/mag/2011
 */
public class NullServerCallService implements IServerCallService {

	@Override
	public <T extends ICommandFacadeResult<?>> AProxy<T> get(IObjectSerializer<T> resultClassSerializer,
			ICallbackAction<T> callbackAction, String url,
			Map<String, String> keyValuesMap) {
		return new NullProxy<T>(callbackAction);
	}

	@Override
	public <T extends ICommandFacadeResult<?>> AProxy<T> delete(IObjectSerializer<T> resultClassSerializer,
			ICallbackAction<T> callbackAction, String url,
			Map<String, String> keyValuesMap) {
		return new NullProxy<T>(callbackAction);
	}

	@Override
	public <T extends ICommandFacadeResult<?>, Z> AProxy<T> post(IObjectSerializer<T> resultClassSerializer,
			IObjectSerializer<Z> dataClassSerializer, ICallbackAction<T> callbackAction, String url,
			Z data) {
		return new NullProxy<T>(callbackAction);
	}

	@Override
	public <T extends ICommandFacadeResult<?>, Z> AProxy<T> put(IObjectSerializer<T> resultClassSerializer,
			IObjectSerializer<Z> dataClassSerializer, ICallbackAction<T> callbackAction, String url,
			Z data) {
		return new NullProxy<T>(callbackAction);
	}


}
