package com.googlecode.jpattern.gwt.client.command;

import com.googlecode.jpattern.gwt.client.IApplicationProvider;
import com.googlecode.jpattern.gwt.client.NullApplicationProvider;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.shared.result.ErrorMessage;
import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * @author Francesco Cina'
 *
 */
public abstract class ACommand {

	private IApplicationProvider provider;
	private ICommandCallBack commandCallBack;

	public final void exec(ICommandCallBack commandCallBack) {
		this.commandCallBack = commandCallBack;
		ILogger logger = getProvider().getLoggerService().getLogger(this.getClass());
		logger.debug("exec");
		IResult commandResult = new CommandResult();
		try{
			exec(commandResult);
		} catch (Exception e) {
			commandResult.getErrorMessages().add(new ErrorMessage("ACommand.generic.error", e.getMessage()));
			getProvider().getLoggerService().getLogger(this.getClass()).error("ACommand.generic.error", e);
		}
	}
	
	protected void callback(IResult commandResult) {
		getCommandCallBack().callback(commandResult);
	}
	
	protected final IApplicationProvider getProvider() {
		if (provider == null) {
			visit( new NullApplicationProvider());
		}
		return provider;
	}
	
	public final void visit(IApplicationProvider provider) {
		this.provider = provider;
	}
	
	protected abstract void exec(IResult commandResult);

	protected final ICommandCallBack getCommandCallBack() {
		if (commandCallBack==null) {
			commandCallBack = new NullCommandCallBack();
		}
		getProvider().getLoggerService().getLogger(this.getClass()).debug("getCommandCallbak " + commandCallBack);
		return commandCallBack;
	}
}
