package com.googlecode.jpattern.gwt.client.communication;

import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;

/**
 * 
 * @author Francesco Cina'
 *
 */
public abstract class AProxy<T extends ICommandFacadeResult<?>> {

	private final ICallbackAction<T> callbackAction;

	public AProxy(ICallbackAction<T> callbackAction) {
		this.callbackAction = callbackAction;
	}
	
	public void call() throws Exception {
		execute(callbackAction);
	}
	
	protected abstract void execute(ICallbackAction<T> callbackAction) throws Exception;
	
}
