package com.googlecode.jpattern.gwt.client.communication;

import com.googlecode.jpattern.gwt.client.command.ACommand;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.gwt.client.util.GenericWrapper;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;
import com.googlecode.jpattern.shared.result.ErrorMessage;
import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * @author Francesco Cina'
 *
 * 07/mag/2011
 */
public abstract class AServerCallCommand<T extends ICommandFacadeResult<?>> extends ACommand {

	
	
	final class ServerCommandCallBack implements ICallbackAction<T> {

		private final IResult commandResult;
		private final GenericWrapper<T> callResult;
		private final ILogger logger;

		public ServerCommandCallBack(IResult commandResult, GenericWrapper<T> callResult) {
			this.logger = getProvider().getLoggerService().getLogger(this.getClass());
			this.commandResult = commandResult;
			this.callResult = callResult;
		}

		@Override
		public void onSuccess(T result) {
			logger.debug("onSuccess ServerCallCommand callback called: " + result.getReturnedObject());
			callResult.setValue(result);
			if (!result.getErrorMessages().isEmpty()) {
				commandResult.getErrorMessages().addAll(result.getErrorMessages());
			}
			callback(commandResult);
		}

		@Override
		public void onError(Throwable exception) {
			commandResult.getErrorMessages().add(new ErrorMessage("Exception on ServerCallCommand callbak", exception.getMessage()));
			logger.error("Exception on ServerCallCommand callbak", exception);
			callback(commandResult);
		}
		
	}
}
