package com.googlecode.jpattern.gwt.client.communication;

import java.util.Date;
import java.util.Map;

import com.google.gwt.http.client.URL;

/**
 * 
 * @author Francesco Cina'
 * 
 */
public class QueryString {

	public static String toQueryString(Map<String, String> keyValuesMap) {
		StringBuilder stringBuilder = new StringBuilder();
		for (String key : keyValuesMap.keySet()) {
			String value = keyValuesMap.get(key);
			stringBuilder.append( stringBuilder.length()==0 ? "?" : "&");
			stringBuilder.append((key != null ? URL.encodeQueryString(key) : ""));
			stringBuilder.append("=");
			stringBuilder.append(value != null ? URL.encodeQueryString(value) : "");
		}
		return stringBuilder.toString();
	}
	
	public static String addTimestampQueryToUrl(String url) {
		String separator = (url.lastIndexOf("?")<0) ? "?" : "&";
		return url + separator + "_ts=" + new Date().getTime();		
	}
}
