package com.googlecode.jpattern.gwt.client.communication;

import java.util.Map;

import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.gwt.client.serializer.IObjectSerializer;
import com.googlecode.jpattern.gwt.client.util.GenericWrapper;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;
import com.googlecode.jpattern.shared.result.ErrorMessage;
import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * @author Francesco Cina'
 *
 * 06/mag/2011
 */
public class ServerCallDeleteCommand<T extends ICommandFacadeResult<?>> extends AServerCallCommand<T> {

	private Map<String, String> keyValuesMap;
	private StringBuffer url;
	private final GenericWrapper<T> callResult;
	
	public ServerCallDeleteCommand(Map<String, String> keyValuesMap, StringBuffer url, GenericWrapper<T> callResult) {
		this.url = url;
		this.keyValuesMap = keyValuesMap;
		this.callResult = callResult;
	}

	@Override
	protected void exec(IResult commandResult) {
		ILogger logger = getProvider().getLoggerService().getLogger(this.getClass());
		logger.debug("Start command execution");
		ServerCommandCallBack commandCallBack = new ServerCommandCallBack(commandResult, callResult);
		IObjectSerializer<T> resultSerializer = getProvider().getSerializerService().getObjectSerializer(callResult.getWrappedClass());
		AProxy<T> proxy = getProvider().getServerCallService().delete(resultSerializer, commandCallBack, url.toString(), keyValuesMap);	
		try {
			proxy.call();
		} catch (Exception exception) {
			commandResult.getErrorMessages().add(new ErrorMessage("Exception on Delete Server call", exception.getMessage()));
			logger.error("Exception on Delete Server call", exception);
		}
	}

}
