package com.googlecode.jpattern.gwt.client.communication;

import java.util.Map;

import com.googlecode.jpattern.gwt.client.cache.ICache;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.gwt.client.util.GenericWrapper;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;
import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * This command uses a cache to reduce the number of calls to the server. Before perform the real get call, it checks if
 * a valid result for this get call is in a global cache (using the ICacheService), if yes the cached value is returned otherwise
 * the get call is performed and the result is stored in the cache.
 * 
 * @author Francesco Cina'
 *
 * 06/mag/2011
 */
public class ServerCallGetCacheableCommand_OLD<T extends ICommandFacadeResult<?>> extends AServerCallCommand<T> {

	private Map<String, String> keyValuesMap;
	private StringBuffer url;
	private final GenericWrapper<T> callResult;
	private final String cacheName;
	
	public ServerCallGetCacheableCommand_OLD(Map<String, String> inKeyValuesMap, StringBuffer url, GenericWrapper<T> callResult, String cacheName) {
		this.cacheName = cacheName;
		this.url = url;
		this.keyValuesMap = inKeyValuesMap;
		this.callResult = callResult;
	}

	@Override
	protected void exec(IResult commandResult) {
		ILogger logger = getProvider().getLoggerService().getLogger(this.getClass());
		logger.debug("Start command execution");
		
		ICache cache = getProvider().getCacheService().getCache(cacheName);
		String completeUrl = url + QueryString.toQueryString(keyValuesMap);
		T cacheResult = cache.get(completeUrl, callResult.getWrappedClass());
		
		if ( cacheResult!=null ) {
			logger.debug("result found in cache [" + cacheName + "], 'get' call will not be performed");
			callResult.setValue(cacheResult);
		} else {		
//			logger.debug("result bot found in cache [" + cacheName + "], performing 'get' call");
//			ServerCommandCallBack commandCallBack = new ServerCommandCallBack(commandResult, callResult);
//			IObjectSerializer<T> resultSerializer = getProvider().getSerializerService().getObjectSerializer(callResult.getWrappedClass());
//			AProxy<T> proxy = getProvider().getServerCallService().get(resultSerializer, commandCallBack, url.toString(), keyValuesMap);	
//			try {
//				proxy.call();
//				if (  ) {
//					
//				}
//			} catch (Exception exception) {
//				commandResult.getErrorMessages().add(new ErrorMessage("Exception on Get Server call", exception.getMessage()));
//				logger.error("Exception on Get Server call", exception);
//			}
		}
	}
}
