package com.googlecode.jpattern.gwt.client.communication.direct;

import java.util.Map;

import com.googlecode.jpattern.gwt.client.ApplicationProxy;
import com.googlecode.jpattern.gwt.client.communication.AProxy;
import com.googlecode.jpattern.gwt.client.communication.ICallbackAction;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;

/**
 * 
 * @author Francesco Cina'
 *
 * @param <T>
 */
public class DeleteProxy<T extends ICommandFacadeResult<?>> extends AProxy<T> {

	private Map<String, String> keyValuesMap;
	private String url;
	private final IServerCallDeleteAction serverCallAction;
	private final Class<T> resultClass;
	

	public DeleteProxy(IServerCallDeleteAction serverCallAction, ICallbackAction<T> callbackAction, Class<T> resultClass, String url, Map<String, String> keyValuesMap) {
		super(callbackAction);
		this.serverCallAction = serverCallAction;
		this.resultClass = resultClass;
		this.url=url;
		this.keyValuesMap = keyValuesMap;
	}
	
	@Override
	protected void execute(ICallbackAction<T> callbackAction) throws Exception {
		ILogger logger = ApplicationProxy.getInstance().getApplicationProvider().getLoggerService().getLogger(this.getClass());

		logger.info("Begin execute - call URL " + url);
		try {
			callbackAction.onSuccess( serverCallAction.delete(resultClass, url, keyValuesMap) );
		} catch (Exception e) {
			callbackAction.onError(e);
		}
	}
}
