package com.googlecode.jpattern.gwt.client.communication.rest;

import java.util.Map;

import com.google.gwt.http.client.RequestBuilder;
import com.googlecode.jpattern.gwt.client.ApplicationProxy;
import com.googlecode.jpattern.gwt.client.communication.AProxy;
import com.googlecode.jpattern.gwt.client.communication.ICallbackAction;
import com.googlecode.jpattern.gwt.client.communication.QueryString;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.gwt.client.serializer.IObjectSerializer;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;

/**
 * 
 * @author Francesco Cina'
 *
 * @param <T>
 */
public class DeleteProxy<T extends ICommandFacadeResult<?>> extends AProxy<T> {

	private Map<String, String> keyValuesMap;
	private String url;
	private final IObjectSerializer<T> jsonBuilder;
	

	public DeleteProxy(ICallbackAction<T> callbackAction, IObjectSerializer<T> jsonBuilder, String url, Map<String, String> keyValuesMap) {
		super(callbackAction);
		this.jsonBuilder = jsonBuilder;
		this.url=url;
		this.keyValuesMap = keyValuesMap;
		
	}
	
	@Override
	protected void execute(ICallbackAction<T> callbackAction) throws Exception {
		ILogger logger = ApplicationProxy.getInstance().getApplicationProvider().getLoggerService().getLogger(this.getClass());
		url += QueryString.toQueryString(keyValuesMap);

		logger.info("Begin execute - call URL " + url);
		
		// Send request to server and catch any errors.
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, QueryString.addTimestampQueryToUrl(url));
		ProxyRequestCallback<T> requestCallBack = new ProxyRequestCallback<T>( callbackAction, jsonBuilder);

		builder.sendRequest(null, requestCallBack);
		logger.debug("End execute - call URL " + url);
	}
}
