package com.googlecode.jpattern.gwt.client.communication.rest;

import com.google.gwt.http.client.RequestBuilder;
import com.googlecode.jpattern.gwt.client.ApplicationProxy;
import com.googlecode.jpattern.gwt.client.communication.AProxy;
import com.googlecode.jpattern.gwt.client.communication.ICallbackAction;
import com.googlecode.jpattern.gwt.client.communication.QueryString;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.gwt.client.serializer.IObjectSerializer;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;

/**
 * 
 * @author Francesco Cina'
 *
 * @param <T>
 */
public class PutProxy<T extends ICommandFacadeResult<?>,Z> extends AProxy<T> {

	private final String url;
	private final Z data;
	private final IObjectSerializer<Z> sendJsonBuilder;
	private final IObjectSerializer<T> resultJsonBuilder;

	public PutProxy( ICallbackAction<T> callbackAction, IObjectSerializer<T> resultJsonBuilder, String url, IObjectSerializer<Z> sendJsonBuilder, Z data) {
		super(callbackAction);
		this.resultJsonBuilder = resultJsonBuilder;
		this.url=url;
		this.sendJsonBuilder = sendJsonBuilder;
		this.data = data;
	}
	
	@Override
	protected void execute(ICallbackAction<T> callbackAction) throws Exception {
		ILogger logger = ApplicationProxy.getInstance().getApplicationProvider().getLoggerService().getLogger(this.getClass());
		
		logger.info("Begin execute - call URL " + url);

		// Send request to server and catch any errors.
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, QueryString.addTimestampQueryToUrl(url));
		builder.setHeader("Content-type", "application/json");
		
		String json = sendJsonBuilder.serialize(data);
		ProxyRequestCallback<T> requestCallBack = new ProxyRequestCallback<T>(callbackAction, resultJsonBuilder);
		builder.sendRequest(json, requestCallBack);
		logger.debug("End execute - call URL " + url);
	}

}
