package com.googlecode.jpattern.gwt.client.event;

import com.googlecode.jpattern.gwt.client.ApplicationProxy;
import com.googlecode.jpattern.gwt.client.IApplicationProvider;
import com.googlecode.jpattern.gwt.client.command.ACommand;
import com.googlecode.jpattern.gwt.client.command.ICommandCallBack;
import com.googlecode.jpattern.gwt.client.logger.ILogger;
import com.googlecode.jpattern.gwt.client.presenter.IPresenter;
import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * @author Francesco Cina'
 *
 * 14 Apr 2011
 */
public abstract class AEvent<T> implements IEvent<T>, ICommandCallBack {
	
	private final IPresenter presenter;
	private IApplicationProvider provider;
	private IEventCallback<T> eventCallback;
	private final ILogger logger;

	public AEvent(IPresenter presenter) {
		this.presenter = presenter;
		this.logger = getProvider().getLoggerService().getLogger(this.getClass());
	}

	/* (non-Javadoc)
	 * @see com.googlecode.jpattern.gwt.event.IEvent#launch()
	 */
	@Override
	public final void launch(IEventCallback<T> eventCallback) {
		this.eventCallback = eventCallback;
		logger.debug("launch");
		presenter.onEventStart();
		ACommand command = exec();
		command.visit(getProvider());
		command.exec(this);
	}

	/* (non-Javadoc)
	 * @see com.googlecode.jpattern.gwt.event.IEvent#callback(com.googlecode.jpattern.gwt.command.IWebResult)
	 */
	@Override
	public final void callback(IResult commandResult) {
		IEventResult<T> eventResult = afertExec(commandResult);
		logger.debug("callback");
		if ( eventResult.getErrorMessages().size()>0 ) {
			logger.warn("Errors appear: " + eventResult.getErrorMessages());
			presenter.onEventError(eventResult.getErrorMessages());
		}
		eventCallback.callback(eventResult);
	}
	
	protected abstract ACommand exec();
	
	protected abstract IEventResult<T> afertExec(IResult webResult);

	public void setProvider(IApplicationProvider provider) {
		this.provider = provider;
	}

	protected IApplicationProvider getProvider() {
		if (provider == null) {
			provider = ApplicationProxy.getInstance().getApplicationProvider();
		}
		return provider;
	}
	
}
