package com.googlecode.jpattern.gwt.client.event;

import com.googlecode.jpattern.gwt.client.presenter.APresenter;
import com.googlecode.jpattern.gwt.client.view.IView;

/**
 * A specific IEventCallBack for the PostDisplay method of an APresenter.
 * This calls the endLoading() method of the presenter after its execution.
 * @author cinafr
 *
 */
public abstract class APostDiplayEventCallBack<T> implements IEventCallback<T> {

	private final APresenter<? extends IView> presenter;

	public APostDiplayEventCallBack(APresenter<? extends IView> presenter) {
		this.presenter = presenter;
	}
	
	@Override
	public void callback(IEventResult<T> webResult) {
		if (webResult.getErrorMessages().isEmpty()) {
			postDisplayCallBack( webResult.getReturnedObject() );
		}
		presenter.render();
	}
	
	public abstract void postDisplayCallBack(T result);
	
}
