package com.googlecode.jpattern.gwt.client.event;

import java.util.List;

import com.googlecode.jpattern.shared.result.IErrorMessage;
import com.googlecode.jpattern.shared.result.IResult;

/**
 * 
 * @author Francesco Cina'
 *
 * 09/mag/2011
 */
public class EventResult<T> implements IEventResult<T> {

	private static final long serialVersionUID = 1L;
	private final T returnedObject;
	private final IResult commandResult;

	public EventResult(IResult commandResult, T resultObject) {
		this.commandResult = commandResult;
		this.returnedObject = resultObject;
	}
	
	@Override
	public List<IErrorMessage> getErrorMessages() {
		return commandResult.getErrorMessages();
	}

	@Override
	public T getReturnedObject() {
		return returnedObject;
	}

	@Override
	public boolean isValid() {
		return commandResult.getErrorMessages().isEmpty();
	}

}
