package com.googlecode.jpattern.gwt.client.history;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.googlecode.jpattern.gwt.client.presenter.IPresenter;

/**
 * 
 * @author Francesco Cina
 *
 * 27/lug/2011
 */
public class FixedSizeHistoryManager implements IHistoryManager, ValueChangeHandler<String> {

	private int count = 0;
	private final int historySize;
	private final Map<String, IPresenter> historyMap = new LinkedHashMap<String, IPresenter>();
	private final List<String> tokenList = new ArrayList<String>();

	public FixedSizeHistoryManager(int historySize) {
		this.historySize = historySize;
		History.fireCurrentHistoryState();
		History.addValueChangeHandler(this);
	}

	@Override
	public void onValueChange(ValueChangeEvent<String> event) {
		IPresenter presenter = historyMap.get(event.getValue());
		if (presenter!=null) {
			presenter.render();
		}
	}

	@Override
	public void registerHistory(String token, IPresenter presenter) {
		if (token!=null && token.length()>0) {
			count++;
			String tokenName = token + count;
			historyMap.put(tokenName, presenter);
			tokenList.add(tokenName);
			History.newItem(tokenName);
			checkHistorySize();
		}
	}

	private void checkHistorySize() {
		if ( tokenList.size() > historySize ) {
			String token = tokenList.get(0);
			historyMap.remove(token);
			tokenList.remove(0);
		}
	}

}
