package com.googlecode.jpattern.gwt.client.logger;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * 
 * @author Francesco Cina'
 *
 * 12 Apr 2011
 */
public class GwtLogger implements ILogger {
	
	private final Logger logger;
	
	public GwtLogger(String name) {
		logger = Logger.getLogger(name);
	}
	
	@Override
	public void trace(String message) {
		logger.finest(message);
		
	}
	
	@Override
	public void debug(String message) {
		logger.fine(message);
	}

	@Override
	public void info(String message) {
		logger.info(message);
	}

	@Override
	public void warn(String message) {
		logger.warning(message);
	}

	@Override
	public void error(String message, Throwable e) {
		logger.log(Level.SEVERE, message, e);
	}

}
