package com.googlecode.jpattern.gwt.client.presenter;

import java.util.List;

import com.googlecode.jpattern.shared.result.IErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 * 20 Apr 2011
 */
public interface IPresenter {

	/**
	 * Clear the error area before the execution of a new event
	 */
	void onEventStart();
	
	/**
	 * Called by the IEvent when the result of the execution is not valid
	 * @param errorMessages
	 */
	void onEventError(List<IErrorMessage> errorMessages);
	
	/**
	 * Bind the presenter's view with his container
	 */
	void render();

	/**
	 * Initialize the presenter and show the related IView
	 */
	void init();
}
