package com.googlecode.jpattern.gwt.client.view;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasWidgets;
import com.googlecode.jpattern.gwt.client.presenter.IPresenter;

/**
 * 
 * @author Francesco Cina'
 *
 * 20 Apr 2011
 */
public abstract class AGwtView<T extends IPresenter> extends Composite implements IView {

	private T presenter;
	private IErrorArea errorArea;
	
	@Override
	public final void render(HasWidgets container) {
	    container.clear();
	    container.add(this);
	}
	

	@SuppressWarnings("unchecked")
	@Override
	public final void visit(IPresenter presenter) {
		this.presenter = (T) presenter;
	}

	@Override
	public final T getPresenter() {
		return presenter;
	}

	@Override
	public IErrorArea getErrorArea() {
		if (errorArea == null) {
			errorArea = buildErrorArea();
		}
		return errorArea;
	}


	/**
	 * Return the IErrorAreaInstance associated to the IView
	 * @return
	 */
	protected abstract IErrorArea buildErrorArea();
	
}
