package com.googlecode.jpattern.gwt.client.view;

import com.google.gwt.user.client.ui.HasWidgets;

/**
 * 
 * A strategy that simply show associated IView
 * 
 * @author Francesco Cina
 *
 * 19/lug/2011
 */
public class DefaultShowViewStrategy<T extends IView> implements IShowViewStrategy<T> {

	private final T view;
	private final HasWidgets container;

	public DefaultShowViewStrategy(T view, HasWidgets container) {
		this.view = view;
		this.container = container;
	}
	
	@Override
	public T getView() {
		return view;
	}

	@Override
	public void onLoadStart() {
			view.render(container);
	}

	@Override
	public void onLoadCompleted() {
			view.render(container);
	}

}
