package com.googlecode.jpattern.gwt.client.view;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;

/**
 * 
 * A strategy that shows a temporary image while asynchronous operations are performed.
 * 
 * @author Francesco Cina
 *
 * 19/lug/2011
 */
public class SwapWidgetShowViewStrategy<T extends IView> implements IShowViewStrategy<T> {

	private final T view;
	private final HasWidgets container;
	private final Widget temporaryWidget;

	public SwapWidgetShowViewStrategy(T view, HasWidgets container, Widget temporaryWidget) {
		this.view = view;
		this.container = container;
		this.temporaryWidget = temporaryWidget;
	}
	
	@Override
	public T getView() {
		return view;
	}

	@Override
	public void onLoadStart() {
		container.clear();
		container.add(temporaryWidget);
	}

	@Override
	public void onLoadCompleted() {
		view.render(container);
	}

}
