package com.googlecode.jpattern.orm;

import com.googlecode.jpattern.orm.crud.IOrmCRUDQuery;
import com.googlecode.jpattern.orm.mapper.IClassMapper;


/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public class OrmClassTool<T> implements IOrmClassTool<T> {

	private final IOrmCRUDQuery ormCRUDQuery;
	private final IClassMapper<T> classMapper;
	private final IOrmPersistor<T> ormPersistor;

	public OrmClassTool(IClassMapper<T> classMapper, IOrmPersistor<T> ormPersistor, IOrmCRUDQuery ormCRUDQuery) {
		this.classMapper = classMapper;
		this.ormPersistor = ormPersistor;
		this.ormCRUDQuery = ormCRUDQuery;
	}
	
	@Override
	public IClassMapper<T> getClassMapper() {
		return classMapper;
	}

	@Override
	public IOrmPersistor<T> getOrmPersistor() {
		return ormPersistor;
	}

	@Override
	public IOrmCRUDQuery getOrmCRUDQuery() {
		return ormCRUDQuery;
	}

}
