package com.googlecode.jpattern.orm.crud;

import com.googlecode.jpattern.orm.annotation.GeneratorType;

/**
 * 
 * @author Francesco Cina
 *
 * 13/giu/2011
 */
public abstract class ColumnValueGeneratorFactory {

	public static AColumnValueGenerator generator(GeneratorType generatorType, String name) {
		if (generatorType.equals( GeneratorType.SEQUENCE ) ) {
			return new SequenceColumnValueGenerator(name);
		}
		if (generatorType.equals( GeneratorType.TABLE ) ) {
			//TODO
			int ciao;
			throw new RuntimeException("TABLE GENERATOR NOT YET IMPLEMENTED");
		}
		return new NullColumnValueGenerator(name);
	}

}
