package com.googlecode.jpattern.orm.crud;

import com.googlecode.jpattern.orm.IOrmConstants;


/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public class OrmCRUDQuery implements IOrmCRUDQuery {

	private final String updateQuery;
	private final String deleteQuery;
	private final String loadQuery;
	private final String saveQuery;
	private final String baseSelectClause;
	private final String baseFromClause;
	private boolean generatedKey;

	public OrmCRUDQuery(String deleteQuery, String loadQuery, String saveQuery, String updateQuery, String baseSelectClause, String baseFromClause, boolean generatedKey) {
		this.deleteQuery = deleteQuery;
		this.loadQuery = loadQuery;
		this.saveQuery = saveQuery;
		this.updateQuery = updateQuery;
		this.baseSelectClause = baseSelectClause;
		this.baseFromClause = baseFromClause;
		this.generatedKey = generatedKey;
	}
	
	@Override
	public String getLoadQuery() {
		return loadQuery;
	}

	@Override
	public String getSaveQuery() {
		return saveQuery;
	}

	@Override
	public String getDeleteQuery() {
		return deleteQuery;
	}

	@Override
	public String getUpdateQuery() {
		return updateQuery;
	}

	@Override
	public boolean generatedKey() {
		return generatedKey;
	}

	@Override
	public String getBaseSelectClause() {
		return getBaseSelectClause(getBaseFromClause() + ".");
	}

	@Override
	public String getBaseFromClause() {
		return baseFromClause;
	}

	@Override
	public String getBaseSelectClause(String rowNamePrefix) {
		return baseSelectClause.replaceAll("\\" + IOrmConstants.ROW_NAME_PREFIX_PLACEHOLDER, rowNamePrefix);
	}

}
