package com.googlecode.jpattern.orm.generator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

import com.googlecode.jpattern.logger.ILogger;
import com.googlecode.jpattern.org.cojen.classfile.CodeBuilder;
import com.googlecode.jpattern.org.cojen.classfile.LocalVariable;
import com.googlecode.jpattern.org.cojen.classfile.TypeDesc;
import com.googlecode.jpattern.orm.exception.OrmConfigurationException;
import com.googlecode.jpattern.orm.logger.OrmLogger;
import com.googlecode.jpattern.orm.mapper.IClassMapper;
import com.googlecode.jpattern.orm.mapper.IColumn;

/**
 * 
 * @author Francesco Cina
 *
 * 04/giu/2011
 */
public class SetterDumpFactory {
	
	private ILogger logger = OrmLogger.getOrmLogger(this.getClass());
	
//	public void visit(CodeBuilder codeBuilder, IClassMapper<?> classMapper, String columnName) {
//		IColumn column = classMapper.getColumnWithJavaName(columnName);
//		logger.debug("visit" , "visit setter method for [" + columnName + "]");
//		logger.debug("visit" , "setter method type: " + column.getField().getType().getName());
//		Field field = column.getField();
//		Method resultSetMethod = MethodHelper.findResultSetGetterForString(field.getType());
//		logger.debug("visit" , "Using " + java.sql.ResultSet.class.getName() + " method: " + resultSetMethod.getName());
//		
//		codeBuilder.loadConstant(classMapper.getColumnWithJavaName(columnName).getName());
//
//		TypeDesc[] params_1 = new TypeDesc[] {TypeDesc.STRING};
//        codeBuilder.invokeInterface(java.sql.ResultSet.class.getName(), resultSetMethod.getName(), TypeDesc.forClass(field.getType()), params_1);
//        TypeDesc[] params_2 = new TypeDesc[] {TypeDesc.forClass(field.getType())};
//        codeBuilder.invokeVirtual(classMapper.getMappedClass().getName(), column.getSetter().getName(), null, params_2);
//	}
	
	public void visit(CodeBuilder codeBuilder, LocalVariable rowNamePrefix, IClassMapper<?> classMapper, String columnName) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
		IColumn column = classMapper.getColumnWithJavaName(columnName);
		logger.debug("visit" , "visit setter method for [" + columnName + "]");
		logger.debug("visit" , "setter method type: " + column.getField().getType().getName());
		Field field = column.getField();
		Method resultSetMethod = MethodHelper.findResultSetGetterForString(field.getType());
		logger.debug("visit" , "Using " + java.sql.ResultSet.class.getName() + " method: " + resultSetMethod.getName());
		
        TypeDesc stringBuilder = TypeDesc.forClass(java.lang.StringBuilder.class.getName());
        codeBuilder.newObject(stringBuilder);
        codeBuilder.dup();
        codeBuilder.loadLocal(rowNamePrefix);
        TypeDesc[] params_0 = new TypeDesc[] {TypeDesc.OBJECT};
        codeBuilder.invokeStatic(java.lang.String.class.getName(), "valueOf", TypeDesc.STRING, params_0);
        TypeDesc[] params_1 = new TypeDesc[] {TypeDesc.STRING};
        codeBuilder.invokeConstructor(java.lang.StringBuilder.class.getName(), params_1);
        
		codeBuilder.loadConstant(classMapper.getColumnWithJavaName(columnName).getName());

		codeBuilder.invokeVirtual(java.lang.StringBuilder.class.getName(), "append", stringBuilder, params_1);
		codeBuilder.invokeVirtual(java.lang.StringBuilder.class.getName(), "toString", TypeDesc.STRING, null);
		
        codeBuilder.invokeInterface(java.sql.ResultSet.class.getName(), resultSetMethod.getName(), TypeDesc.forClass(field.getType()), params_1);
        TypeDesc[] params_2 = new TypeDesc[] {TypeDesc.forClass(field.getType())};
        codeBuilder.invokeVirtual(classMapper.getMappedClass().getName(), column.getSetter().getName(), null, params_2);
	}
	
	public void visit(CodeBuilder codeBuilder, IClassMapper<?> classMapper,  String columnName, int columnIndex) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
		IColumn column = classMapper.getColumnWithJavaName(columnName);
		logger.debug("visit" , "visit setter method for [" + columnName + "]");
		logger.debug("visit" , "setter method type: " + column.getField().getType().getName());
		Field field = column.getField();
		Method resultSetMethod = MethodHelper.findResultSetGetterForInt(field.getType());
		logger.debug("visit" , "Using " + java.sql.ResultSet.class.getName() + " method: " + resultSetMethod.getName());
		
		codeBuilder.loadConstant(columnIndex);
        
        TypeDesc[] params_1 = new TypeDesc[] {TypeDesc.INT};
        codeBuilder.invokeInterface(java.sql.ResultSet.class.getName(), resultSetMethod.getName(), TypeDesc.forClass(field.getType()), params_1);
        TypeDesc[] params_2 = new TypeDesc[] {TypeDesc.forClass(field.getType())};
        codeBuilder.invokeVirtual(classMapper.getMappedClass().getName(), column.getSetter().getName(), null, params_2);
        
	}
	
}
