package com.googlecode.jpattern.orm.generator;

import java.security.SecureClassLoader;

/**
 * 
 * @author Francesco Cina
 *
 * 01/lug/2011
 */
public class ThreadClassLoader extends SecureClassLoader implements IClassLoader {

	public ThreadClassLoader() {
		super(Thread.currentThread().getContextClassLoader());
	}
	
	@Override
	public Class<?> define(String name, byte[] bytes) {
		return super.defineClass(name, bytes, 0, bytes.length);
	}

}
