package com.googlecode.jpattern.orm.mapper;

import java.util.Map;

/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public class ClassMapper<T> implements IClassMapper<T> {

	private final Class<T> mappedClass;
	private final Map<String, IColumn> fieldColumnMapping;
	private String[] allColumnJavaNames = new String[0];
	private String[] allNotGeneratedColumnJavaNames = new String[0];
	private String[] primaryKeyColumnJavaNames = new String[0];
	private String[] notPrimaryKeyColumnJavaNames = new String[0];
	private String[] allGeneratedColumnJavaNames = new String[0];
	private String[] allGeneratedColumnDBNames = new String[0];
	private final ITableMap tableMap;
//	private IOrmLogger logger = OrmLogger.getOrmLogger(this.getClass());

	public ClassMapper(Class<T> mappedClass, ITableMap tableMap, Map<String, IColumn> fieldColumnMapping) {
		this.mappedClass = mappedClass;
		this.tableMap = tableMap;
		this.fieldColumnMapping = fieldColumnMapping;
	}
	
	@Override
	public Class<T> getMappedClass() {
		return mappedClass;
	}

	@Override
	public IColumn getColumnWithJavaName(String javaName) {
		if (fieldColumnMapping.containsKey(javaName)) {
			return fieldColumnMapping.get(javaName);
		}
		return new NullColumn();
	}

	@Override
	public String[] getAllColumnJavaNames() {
		return allColumnJavaNames;
	}

	@Override
	public String[] getPrimaryKeyColumnJavaNames() {
		return primaryKeyColumnJavaNames;
	}

	@Override
	public String[] getNotPrimaryKeyColumnJavaNames() {
		return notPrimaryKeyColumnJavaNames;
	}

	public void setAllColumnJavaNames(String[] allColumnJavaNames) {
		this.allColumnJavaNames = allColumnJavaNames;
	}

	public void setPrimaryKeyColumnJavaNames(String[] primaryKeyColumnJavaNames) {
		this.primaryKeyColumnJavaNames = primaryKeyColumnJavaNames;
	}

	public void setNotPrimaryKeyColumnJavaNames(String[] notPrimaryKeyColumnJavaNames) {
		this.notPrimaryKeyColumnJavaNames = notPrimaryKeyColumnJavaNames;
	}

	@Override
	public ITableMap getTableMap() {
		return tableMap;
	}

	public void setAllNotGeneratedColumnJavaNames(String[] allNotGeneratedColumnJavaNames) {
		this.allNotGeneratedColumnJavaNames = allNotGeneratedColumnJavaNames;
	}

	@Override
	public String[] getAllNotGeneratedColumnJavaNames() {
		return allNotGeneratedColumnJavaNames;
	}
	
	public void setAllGeneratedColumnJavaNames(String[] allGeneratedColumnJavaNames) {
		this.allGeneratedColumnJavaNames = allGeneratedColumnJavaNames;
	}

	@Override
	public String[] getAllGeneratedColumnJavaNames() {
		return allGeneratedColumnJavaNames;
	}

	public void setAllGeneratedColumnDBNames(String[] allGeneratedColumnDBNames) {
		this.allGeneratedColumnDBNames = allGeneratedColumnDBNames;
	}

	public String[] getAllGeneratedColumnDBNames() {
		return allGeneratedColumnDBNames;
	}
	
}
