package com.googlecode.jpattern.orm.mapper;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.googlecode.jpattern.logger.ILogger;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.logger.OrmLogger;

/**
 * 
 * @author Francesco Cina
 *
 * 13/giu/2011
 */
public class DBTableMapBuilder implements ITableMapBuilder {

	private final Connection connection;
	private final ITableMap tableMap;
	private ILogger logger = OrmLogger.getOrmLogger(this.getClass());
	private final boolean enableDBScan;

	public DBTableMapBuilder(Connection connection, ITableMap tableMap, boolean enableDBScan) {
		this.connection = connection;
		this.tableMap = tableMap;
		this.enableDBScan = enableDBScan;
	}
	
	@Override
	public void updateTableMap() throws SQLException {
		if (enableDBScan) {
			try { 
				mapField(tableMap.getSchemaName(), tableMap.getTableName());
			} finally {
				if (connection != null) {
					try {
						connection.close();
					} catch (SQLException e) {
						throw new OrmException(e);
					}
				}
			}
		}
	}

	private void mapField(String schemaName, String tableName) throws SQLException {
		exploreMetaData(schemaName, tableName);
	}
	
	private void exploreMetaData(String schemaName, String tableName) throws SQLException {
        DatabaseMetaData dbmd = null;
        dbmd = connection.getMetaData();
        String schema = null;
        if (schemaName!=null && schemaName.length()>0) {
        	schema = schemaName;
        }
        if (tableMap.getPrimaryKeyFieldNames().size()==0) {
    		logger.info("getPrimaryKeyColumns", "No annotations used to identify primary keys. Search them in the DB metadata.");
	    	ResultSet res;
	        res = dbmd.getPrimaryKeys(null, schema, tableName);
	        while (res.next()) {
	        	tableMap.getPrimaryKeyFieldNames().add( tableMap.getJavaFieldName( res.getString(Constant.COLUMN_NAME) ) );
	        }
	        res.close();
    	} else {
    		logger.info("getPrimaryKeyColumns", "Annotations are used to identify primary keys. DB metadata will not be used to retrieve primary keys.");
    	}
        logger.info("getPrimaryKeyColumns", "following field will be used as primary key for table " + schemaName + "." + tableName + ": " + tableMap.getPrimaryKeyFieldNames());
    }
	
}
