package com.googlecode.jpattern.orm.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.googlecode.jpattern.orm.crud.AColumnValueGenerator;
import com.googlecode.jpattern.orm.crud.NullColumnValueGenerator;

/**
 * 
 * @author Francesco Cina
 *
 * 08/giu/2011
 */
public class TableMap implements ITableMap {

	private List<String> primaryKeyFieldList = new ArrayList<String>();
	private Map<String, String> columnNamesMap = new HashMap<String, String>();
	private Map<String, String> javaFieldNamesMap = new HashMap<String, String>();
	private Map<String, AColumnValueGenerator> generatorByColumnName = new HashMap<String, AColumnValueGenerator>();
	private Map<String, AColumnValueGenerator> generatorByJavaFieldName = new HashMap<String, AColumnValueGenerator>();
	private String schemaName;
	private String tableName;

	@Override
	public String getSchemaName() {
		if (schemaName==null) {
			schemaName = "";
		}
		return schemaName;
	}

	@Override
	public String getTableName() {
		if (tableName==null) {
			tableName = "";
		}
		return tableName;
	}
	
	@Override
	public String getTableNameWithSchema() {
		String schema = getSchemaName();
		if (schema.length()==0) {
			return getTableName();
		}
		return schema + "." + getTableName();
	}

	public void addColumnMapping(String javaFieldName, String columnName, AColumnValueGenerator columnValueGenerator) {
		if ( (javaFieldName!=null) && (columnName!=null) ) {
			columnNamesMap.put(javaFieldName, columnName);
			javaFieldNamesMap.put(columnName, javaFieldName);
			generatorByColumnName.put(columnName, columnValueGenerator);
			generatorByJavaFieldName.put(javaFieldName, columnValueGenerator);
		}
	}
	
	@Override
	public String getDBColumnName(String javaFieldName) {
		if (columnNamesMap.containsKey(javaFieldName)) {
			return columnNamesMap.get(javaFieldName);
		}
		return "";
	}
	
	@Override
	public String getJavaFieldName(String dbColumnName) {
		if (javaFieldNamesMap.containsKey(dbColumnName)) {
			return javaFieldNamesMap.get(dbColumnName);
		}
		return "";
	}

	@Override
	public List<String> getPrimaryKeyFieldNames() {
		return primaryKeyFieldList;
	}
	
	public void addPrimaryKey(String primaryKeyField) {
		primaryKeyFieldList.add(primaryKeyField);
	}

	public void setSchemaName(String schemaName) {
		this.schemaName = schemaName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	@Override
	public List<String> getAllFieldNames() {
		return new ArrayList<String>( columnNamesMap.keySet() );
	}

	@Override
	public AColumnValueGenerator getGeneratorByColumnName(String columnName) {
		if (generatorByColumnName.containsKey(columnName))  {
			return generatorByColumnName.get(columnName);
		}
		return new NullColumnValueGenerator("");
	}

	@Override
	public AColumnValueGenerator getGeneratorByJavaFieldName(String javaFieldName) {
		if (generatorByJavaFieldName.containsKey(javaFieldName))  {
			return generatorByJavaFieldName.get(javaFieldName);
		}
		return new NullColumnValueGenerator("");
	}

}
