package com.googlecode.jpattern.orm.query;

import java.util.List;

import com.googlecode.jpattern.orm.NullOrmClassToolMap;
import com.googlecode.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina
 *
 * 08/lug/2011
 */
public abstract class ABaseOrmQuery extends AQuery implements IBaseOrmQuery {

	private IExpression whereExpression = new Expression();
	private OrderBy orderBy = new OrderBy();
	private IJoin join = new Join(new NullOrmClassToolMap());

	@Override
	public final IJoin join() throws OrmException {
		return join;
	}

	@Override
	public final IExpression where() throws OrmException {
		return whereExpression;
	}

	@Override
	public final IOrderBy orderBy() throws OrmException {
		return orderBy;
	}

	protected final void setWhere(IExpression whereExpression) {
		this.whereExpression = whereExpression;
	}

	protected final void setOrderBy(OrderBy orderBy) {
		this.orderBy = orderBy;
	}

	protected final void setJoin(IJoin join) {
		this.join = join;
	}
	
	@Override
	public final String renderSql() {
		StringBuffer stringBuffer = new StringBuffer();
		renderSql(stringBuffer);
		return stringBuffer.toString();
	}
	
	@Override
	public final void renderSql(StringBuffer stringBuffer) {
		renderSelect(stringBuffer);
		renderFrom(stringBuffer);
		renderWhere(stringBuffer);
		renderOrderBy(stringBuffer);
	}

	protected abstract void renderOrderBy(StringBuffer stringBuffer);

	protected abstract void renderWhere(StringBuffer stringBuffer);

	protected abstract void renderFrom(StringBuffer stringBuffer);

	protected abstract void renderSelect(StringBuffer stringBuffer);

	@Override
	public final void appendValues(List<Object> values) {
		where().appendValues(values);
	}
}
