package com.googlecode.jpattern.orm.query;

import com.googlecode.jpattern.orm.exception.OrmException;

public abstract class AQuery implements IQuery {

	private int queryTimeout = 0;
	private int maxRows = 0;

	@Override
	public final int getMaxRows() throws OrmException {
		return maxRows;
	}

	@Override
	public final IQuery setQueryTimeout(int queryTimeout) {
		this.queryTimeout = queryTimeout;
		return this;
	}

	@Override
	public final int getQueryTimeout() {
		return queryTimeout;
	}

	@Override
	public final IQuery setMaxRows(int maxRows) throws OrmException {
		this.maxRows = maxRows;
		return this;
	}

}
